# Copyright 1999-2015. Parallels IP Holdings GmbH. All Rights Reserved.
package LegacyPanel::EntityFactory;

use strict;
use warnings;

=pod

LegacyPanel::EntityFactory - magic factory to produce entites. 

Done that way to provide loose coupling between exact entites and algorithms to retrieve them.

=cut

sub new($%) {
  my ($class, %entityClassNames) = @_;
  my $self = { };
  bless $self, $class;

  $self->_init(%entityClassNames);

  return $self;
}

sub _init($%) {
  my ($self, %entityClassNames) = @_;

  eval {
    while( my ($entity, $className) = each(%entityClassNames)) {
      require $className . '.pm';
    }
  };
  if ($@) {
    die "Can't load entity classes: " . $@;
  }
  $self->{'entity'} = { %entityClassNames };
}

sub get($$@) {
  my ($self, $entityType, @parameters) = @_;
  my $className = $self->{'entity'}->{$entityType};

  if (scalar(@parameters)) {
    return $className->new(@parameters);
  } else {
    return $className->new();
  }
}

=pod

getAllEntityIdList - magic method to retrieve all entities of the some type.

=cut

sub getAllEntityIdList($$) {
  my ($self, $entityName) = @_;
  my $className = $self->{'entity'}->{$entityName};
  
  if ($className->can('GetIdList')) {
    return $className->GetIdList();
  } else {
    return ();
  }
} 

1;

