from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.plesk.source.confixx import messages
from parallels.core.actions.base.legacy_action \
	import LegacyAction
from parallels.plesk.actions.hosting_settings.convert.dns \
	import DNS as ActionHostingSettingsConvertDNS

from parallels.plesk.source.confixx.actions.content.web.copy_unix_content \
	import ConfixxCopyUnixWebContent
from parallels.plesk.source.confixx.actions.content.web.fix_permissions \
	import FixPermissions


class WorkflowExtension(WorkflowExtensionBase):
	def extend_workflow(self, workflow):
		"""Extend shared hosting workflow with source-panel specific actions

		:type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
		"""
		workflow.get_shared_action('convert-hosting').replace(
			'convert-dns', ActionHostingSettingsConvertDNS()
		)

		workflow.get_shared_action('copy-web-files').insert_action(
			'copy-files', ConfixxCopyUnixWebContent()
		)
		workflow.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions', FixPermissions()
		)
		workflow.get_path('check/check-data').insert_action(
			'check-additional', LegacyAction(
				description='Check additional',
				function=lambda ctx: ctx.migrator._check_additional(ctx.pre_check_report)
			)
		)

		workflow.get_shared_action('fetch-source').insert_action(
			'fetch-data', LegacyAction(
				description=messages.FETCH_DATA_FROM_SOURCE_CONFIXX,
				function=lambda ctx: ctx.migrator._fetch_source(
					ctx.options, ctx.options.reload_source_data
				)
			)
		)
