import logging

from parallels.core import MigrationError
from parallels.core.actions.base.common_action import CommonAction
from parallels.ppa.utils.xml_rpc.poa import poa_api
from parallels.ppa import messages

logger = logging.getLogger(__name__)


class RemoveWebspace(CommonAction):
	def get_description(self):
		return messages.REMOVE_WEBSPACE_FROM_PPA

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return messages.FAILED_TO_REMOVE_WEBSPACE_FROM_PPA

	def run(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		try:
			webspace_id = int(global_context.options.webspace_id)
		except ValueError:
			logger.debug(u"Exception:", exc_info=True)
			raise MigrationError(messages.WEBSPACE_ID_SPECIFIED_BY_WEBSPACEID_OPTION)

		try:
			global_context.conn.target.poa_api().remove_webspace(webspace_id)
		except poa_api.PoaApiError as e:
			logger.debug(u"Exception:", exc_info=True)
			raise MigrationError(u"Failed to remove the webspace: %s" % (str(e),))

		logger.info(messages.WEBSPACE_REMOVE_SCHEDULED_PLEASE_CHECK_PPA)