from parallels.common.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.common.actions.utils.logging_properties \
	import LoggingProperties
from parallels.common.target_panels import TargetPanels
from parallels.common.checking import Problem

class Maillists(SubscriptionBackupAction):
	"""Check if there are maillists in backup
	
	PPA doesn't support Mailman yet, warn user that we can't restore them.
	"""
	def get_description(self):
		return "Check maillists"

	def get_failure_message(self, global_context, subscription):
		return "Failed to check for maillists for subscription '%s'" % (subscription.name)

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		if global_context.target_panel != TargetPanels.PPA:
			# applicable to PPA only, for Plesk we can restore maillists
			# without any issues
			return

		if subscription_backup.has_maillists():
			subscription.add_report_issue(
				global_context.pre_check_report,
				Problem(
					'subscription_has_maillists', Problem.WARNING, 
					u"Subscription has some mail list(s). Mail lists are not supported by PPA."
				),
				u"Mail lists won't be migrated."
			)
