from parallels.common.actions.base.subscription_backup_action import SubscriptionBackupAction
from parallels.common.actions.utils.logging_properties \
	import LoggingProperties
from parallels.common.target_panels import TargetPanels

class RemoveMaillists(SubscriptionBackupAction):
	"""Remove maillist definitions from backup.
	
	PPA doesn't support Mailman yet. Restoring maillists from backup causes
	issue which says that mail list service isn't available."""

	def get_description(self):
		return "Remove maillists backup"

	def get_failure_message(self, global_context, subscription):
		return "Failed to remove maillists for subscription '%s'" % (subscription.name)

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		if global_context.target_panel != TargetPanels.PPA:
			# applicable to PPA only, for Plesk we can restore maillists
			# without any issues
			return

		subscription_backup.remove_maillists()
