from collections import namedtuple

from parallels.utils import obj, extend_namedtuple
from parallels.common.utils.yaml_utils import pretty_yaml

YAML_PREFIX = 'import_api'

ADMIN_ACCOUNT_ID = 1

# namedtuple with pretty YAML serialization
def model_pretty_yaml(namedtuple_class):
	return pretty_yaml(namedtuple_class, prefix=YAML_PREFIX)

# the three data types below contain only the information needed for conflicts check
BaseContactInfo = model_pretty_yaml(namedtuple('BaseContactInfo', (
	'username', 'email', 'first_name', 'last_name'
)))
BaseCustomerInfo = model_pretty_yaml(namedtuple('BaseCustomerInfo', (
	'id', 
	'contact' # instance of ContactInfo
)))
BaseResellerInfo = model_pretty_yaml(namedtuple('BaseResellerInfo', (
	'id', 
	'contact' # instance of ContactInfo
)))

# unlike ppa_api.WebspaceInfo, the WebspaceInfo type here has status_reason, describing the error that happened
# when asynchronously processing the createWebspace request.
BaseWebspaceInfoBrief = model_pretty_yaml(namedtuple('BaseWebspaceInfoBrief', ('webspace_id', 'name')))
BaseWebspaceInfo = model_pretty_yaml(extend_namedtuple(BaseWebspaceInfoBrief, 'BaseWebspaceInfo', (
	'subscription_id', 
	'owner_id', 
	'status', # one of WebspaceStatus
)))
BaseServiceTemplateInfo = model_pretty_yaml(namedtuple('BaseServiceTemplateInfo', ('st_id', 'name', 'owner_id')))
BaseSubscriptionInfo = model_pretty_yaml(namedtuple('BaseSubscriptionInfo', (
	'subscription_id', 'owner_id', 'st_id', 'name', 'is_active', 
)))
WebspaceStatus = obj(ACTIVE = 'active', PENDING = 'pending', SUSPENDED = 'suspended', FAILED = 'failed')
