from collections import namedtuple

from .. import core

DomainAliasInfo = namedtuple('DomainAliasInfo', ('id', 'name', 'domain_id'))

class DomainAliasOperator:
	FilterAll = core.FilterAll
	FilterByDomainName = core.declare_filter('FilterByDomainName', 'domain_name')
	FilterByName = core.declare_filter('FilterByName', 'name')

	class Get(core.operation_with_filter('Get')):
		operator_name = 'domain_alias'
		operation_name = 'get'
		min_api_version = '1.4.0.0'
		max_api_version = '1.6.5.0'

		@classmethod
		def parse(cls, elem):
			return core.parse_result_set(elem, cls._parse_data, 'id')

		@classmethod
		def _parse_data(cls, elem):
			id = int(elem.findtext('id'))
			domain_id = int(elem.findtext('info/domain_id'))
			name = elem.findtext('info/name')

			return (id, DomainAliasInfo(id = id, name = name, domain_id = domain_id))

