from parallels.common import messages
from parallels.common.actions.base.common_action import CommonAction
from parallels.common.actions.utils.logging_properties import LoggingProperties


class ShutdownWindowsRsyncServers(CommonAction):
	def get_description(self):
		return messages.SHUTDOWN_WINDOWS_RSYNC_SERVERS

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return messages.FAILED_SHUTDOWN_WINDOWS_RSYNC_SERVERS

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed, migration tool won't run the next operations.

		:rtype: bool
		"""
		return False

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		global_context.rsync_pool.stop_all()

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)
