from collections import namedtuple
from contextlib import contextmanager

TargetServers = namedtuple('TargetServers', (
	'web',  # instance of TargetServer
	'mail',  # instance of TargetServer
	'database',  # dictionary with key - database type, value - instance of TargetDatabaseServer
	'dns',  # instance of TargetServer
))


class TargetServer(object):
	"""Base interface to interact with target server
	and get various common information about it.
	"""

	@contextmanager
	def runner(self):
		raise NotImplementedError()

	def is_windows(self):
		raise NotImplementedError()

	def description(self):
		raise NotImplementedError()

	def ip(self):
		raise NotImplementedError()

	def get_session_file_path(self, filename):
		raise NotImplementedError()

	def session_dir(self):
		raise NotImplementedError()

	def __hash__(self):
		"""Implement for using nodes as dictionary keys, for the purpose of grouping"""
		raise NotImplementedError()

	def __eq__(self, another):
		"""Implement for using nodes as dictionary keys, for the purpose of grouping"""
		raise NotImplementedError()