from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import PostgreSQLDatabaseIssueType as IT

MESSAGES = {}

MESSAGES[IT.FAILED_TO_FETCH_TABLES_FROM_SOURCE] = format_message("""
Failed to retrieve information about database tables on the source PostgreSQL database server '{server}': {reason}
Checking of tables of the database '{database}' on the target host will be skipped.
""")

MESSAGES[IT.FAILED_TO_FETCH_TABLES_FROM_TARGET] = format_message("""
Failed to retrieve information about database tables on the target PostgreSQL database server '{server}': {reason}
Checking of tables of the database '{database}' on the target host will be skipped.
""")

MESSAGES[IT.DIFFERENT_TABLES_SET] = format_message("""
PostgreSQL database '{database}' on the source server and on the target server has a differing set of tables. 
The databases that are present on the source server, but are missing at the target server: {tables_list}
""")

MESSAGES[IT.FAILED_TO_EXECUTE_SIMPLE_QUERY_AS_USER] = format_message("""
Failed to execute a simple SQL query 'SELECT 1' under user '{user}' for PostgreSQL database '{database}'
""")

MESSAGES[IT.DATABASE_DOES_NOT_EXIST_IN_PANEL] = format_message("""
PostgreSQL database '{database}' does not exist on the target panel.
All the other checks for that database will be skipped.
""")

MESSAGES[IT.DATABASE_USER_DOES_NOT_EXIST_IN_PANEL] = format_message("""
Database user '{user}' does not exist for PostgreSQL database '{database}' on target panel
""")

MESSAGES[IT.PSQL_CLIENT_GENERIC_ERROR] = format_message("""
Failed to connect to database '{database}' on target PostgreSQL server
'{server}' with 'psql' client. 
PostgreSQL client STDOUT: {stdout}
PostgreSQL client STDERR: {stderr}
""")

MESSAGES[IT.CONNECTION_ERROR] = format_message("""
Failed to connect to database '{database}' on target PostgreSQL server '{server}'. 
""")

MESSAGES[IT.DATABASE_DOES_NOT_EXIST] = format_message("""
Database '{database}' does not exist on target PostgreSQL server '{server}'. 
""")

MESSAGES[IT.INTERNAL_ERROR] = format_message("""
An internal error occurred: {reason}
Unable to check whether the PostgreSQL database '{database}' was migrated correctly.
""")
