from parallels.plesks_migrator import messages
from parallels.common.actions.base.subscription_action import SubscriptionAction
from parallels.common.utils import plesk_utils

SUSPEND_SUBSCRIPTION_CONFIG_OPTION = 'suspend-source-subscription'

class SuspendSubscriptions(SubscriptionAction):
	def get_description(self):
		return messages.ACTION_SUSPEND_SOURCE_SUBSCRIPTION_FOR_COLD_MIGRATION_DESCRIPTION

	def get_failure_message(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		return messages.ACTION_SUSPEND_SOURCE_SUBSCRIPTION_FOR_COLD_MIGRATION_FAILURE

	def filter_subscription(self, global_context, subscription):
		"""
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return self._is_cold_migration_option_enabled(global_context.config)

	def run(self, global_context, subscription):
		"""
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		plesk_utils.suspend_subscription(subscription.web_source_server, subscription.name_idn)

	@staticmethod
	def _is_cold_migration_option_enabled(config):
		"""
		:type config: ConfigParser.RawConfigParser
		"""
		return SUSPEND_SUBSCRIPTION_CONFIG_OPTION in config.options('GLOBAL') \
			and config.getboolean('GLOBAL', SUSPEND_SUBSCRIPTION_CONFIG_OPTION)
