# Copyright 1999-2012. Parallels IP Holdings GmbH. All Rights Reserved.
package BackupDumpStatus;

use strict;
use DumpStatus;

use vars qw|@ISA|;

@ISA = qw|DumpStatus|;

sub _init {
  my ($self, @args) = @_;
  $self->SUPER::_init(@args);

  $self->{fh} = undef;
}

sub setOutput {
  my ($self, $fh) = @_;
  $self->{fh} = $fh;
}

sub _bar {
  my ($self) = @_;
  $self->{fh}->print(("-" x 72) . "\n");
}

sub start {
  my ($self, $clients, $domains) = @_;

  if (defined $self->{fh}) {
    $self->_bar();
    if ($clients > 0) {
      $self->{fh}->print("Backup started ($clients client(s), $domains domain(s))\n");
    }
    else {
      $self->{fh}->print("Backup started. ($domains domains)\n");
    }
    $self->{fh}->print("Start date: " . gmtime() . "\n");
    $self->_bar();
    $self->{fh}->print("Phase 1/2: collecting information\n");
  }

  $self->{has_clients} = $clients > 0;
}

sub startDomain {
  my ($self, $domain) = @_;

  if (defined $self->{fh}) {
    if ($self->{has_clients}) {
      $self->{fh}->print("  [domain] $domain\n");
    }
    else {
      $self->{fh}->print("[domain] $domain\n");
    }
  }
}

sub endDomain {
  my ($self, $domain) = @_;
}

sub startClient {
  my ($self, $client) = @_;

  if (defined $self->{fh}) {
    $self->{fh}->print("[client] $client\n");
  }
}

sub endClient {
  my ($self, $client) = @_;
}

#
# Invoked before $storage->finish();
#
sub finishObjects {
  my ($self) = @_;

  if (defined $self->{fh}) {
    $self->{fh}->print("Phase 2/2: packing data\n");
  }
}

sub finish {
  my ($self) = @_;
  if (defined $self->{fh}) {
    $self->_bar();
    $self->{fh}->print("Backup finished.\n");
    $self->{fh}->print("Finish date: " . gmtime() . "\n");
    $self->_bar();
  }
}




1;