import logging

from parallels.common.utils.config_utils import ConfigSection
from parallels.plesks_migrator.connections import PleskMigratorConnections
from parallels.shm_move_webspaces.source_server import PPAMoveWebspacesSourceServer
from parallels.target_panel_ppa.connections.target_connections import  PPATargetConnections
from parallels.utils import cached
from parallels.utils import merge_dicts

logger = logging.getLogger(__name__)

class PPAMoveWebspacesWebSnSourceConnections(PleskMigratorConnections):
	def __init__(self, config, target_panel, migrator_server):
		super(PPAMoveWebspacesWebSnSourceConnections, self).__init__(config, target_panel, migrator_server)
		self.mn_server = PPATargetConnections(config)

	@cached
	def get_source_node(self, node_id):
		all_servers = merge_dicts(
			self.get_source_plesks(), self.get_external_db_servers()
		)
		node_settings = all_servers[node_id]
		return PPAMoveWebspacesSourceServer(
			node_id, node_settings, self._migrator_server, '12.1', self.mn_server
		)

	@staticmethod
	def _read_web_sn_settings(config, section_name):
		section = ConfigSection(config, section_name)
		settings = {}
		for name in ['ip', 'os']:
			settings[name] = section[name]
		return settings
