from parallels.common.actions.base.entry_point_action import EntryPointAction
from parallels.common.actions.base.legacy_action import LegacyAction
from parallels.common.actions.hosting_settings.check.check_database_conflicts import CheckDatabaseConflicts
from parallels.common.utils.backup_adapter import SubscriptionBackupRaw
from parallels.target_panel_plesk.actions.check_target_license_limits import CheckTargetLicenseLimits
from parallels.target_panel_plesk.actions.create_hosting_plans import CreateHostingPlans
from parallels.target_panel_plesk.actions.create_reseller_plans import CreateResellerPlans
from parallels.target_panel_plesk.actions.convert import ConvertAuxUsers
from parallels.target_panel_plesk.actions.convert import ConvertAuxUserRoles
from parallels.common.actions.restore.auxusers import RestoreAuxUsers
from parallels.common.actions.restore.auxuser_roles import RestoreAuxUserRoles
from parallels.target_panel_plesk.actions.live_migration import LiveMigration
from parallels.target_panel_plesk.actions.re_sync_web_files_after_live_migration import ReSyncWebFilesAfterLiveMigration


def extend_workflow_with_plesk_actions(workflow):
	"""Extend shared hosting workflow with plesk-specific actions

	:type workflow parallels.common.workflow.base_workflow.BaseWorkflow
	:rtype None
	"""

	# Automatically create resellers and plans when migrating to Plesk.
	# It means that customer can run migration in just one simple step
	# - "transfer-accounts" with no need to remember "import-resellers"
	# and "import-plans". Unfortunately we can't do the same for PPA.
	# It has much more complex model, and we can't automate creating
	# reseller subscriptions and configuring their plans.
	workflow.get_path('transfer-accounts').insert_action('import-resellers', LegacyAction(
		description='Import resellers',
		function=lambda ctx: ctx.migrator._import_resellers(ctx.options)
	), after='fetch-target')
	workflow.get_path('transfer-accounts').insert_action(
		'import-plans', CreateHostingPlans(), after='import-resellers'
	)
	# Re-fetch data for further conversions to detect new resellers and
	# their plans
	workflow.get_path('transfer-accounts').insert_action(
		'refetch-source', workflow.get_shared_action('fetch-source'),
		after='import-plans'
	)
	workflow.get_path('transfer-accounts').insert_action(
		'refetch-target', workflow.get_shared_action('fetch-target'),
		after='refetch-source'
	)

	workflow.get_path('transfer-accounts').insert_action(
		'check-plesk-infrastructure', 
		workflow.get_shared_action_pointer('check-infrastructure'),
		after='convert'
	)
	workflow.get_path('transfer-accounts').insert_action(
		'create-admin-reseller-plans',
		CreateResellerPlans(),
		before='import-resellers'
	)
	workflow.get_path('import-resellers').insert_action(
		'create-admin-reseller-plans',
		CreateResellerPlans(),
		before='import-resellers'
	)
	workflow.get_path('transfer-accounts').insert_action(
		'convert-aux-user-roles', ConvertAuxUsers(), after='convert')
	workflow.get_path('transfer-accounts').insert_action(
		'convert-aux-user-roles', ConvertAuxUserRoles(), after='convert')
	workflow.get_path('transfer-accounts').insert_action(
		'restore-auxusers', RestoreAuxUsers(), after='restore')
	workflow.get_path('transfer-accounts').insert_action(
		'restore-auxuser-roles', RestoreAuxUserRoles(), after='restore')
	workflow.get_path('transfer-accounts').insert_action(
		'live-migration', LiveMigration(), after='copy-content')
	workflow.get_path('transfer-accounts').insert_action(
		're-sync-web-files', ReSyncWebFilesAfterLiveMigration(), after='live-migration')

	# For Plesk, we can perform the database conflicts check on pre-migration
	# as we know target database server location
	workflow.get_path('check/check-data').insert_action(
		'check-database-conflicts',
		CheckDatabaseConflicts(SubscriptionBackupRaw())
	)

	workflow.get_path('check/check-data').insert_action(
		'check-target-license-limits', CheckTargetLicenseLimits()
	)
	workflow.get_path('transfer-accounts').insert_action(
		'check-target-license-limits', CheckTargetLicenseLimits(), before='convert'
	)

	_configure_entry_point_import_plans(workflow)


def _configure_entry_point_import_plans(workflow):
	workflow.replace_entry_point('import-plans', EntryPointAction())
	workflow.get_path('import-plans').insert_actions(
		workflow.get_shared_action('initial-pre-checks').get_all_actions()
	)
	workflow.get_path('import-plans').insert_action(
		'fetch-source',
		workflow.get_shared_action('fetch-source')
	)
	workflow.get_path('import-plans').insert_action(
		'import-plans', CreateHostingPlans()
	)
	workflow.get_path('import-plans').insert_action(
		'cleanup',
		workflow.get_shared_action('cleanup')
	)
	workflow.get_path('import-plans').register_overall_shutdown('cleanup')