from parallels.core.actions.base.subscription_action \
	import SubscriptionAction


class SubscriptionBackupAction(SubscriptionAction):
	"""Action performed to change subscription's backup"""

	def __init__(self, subscription_backup):
		"""Class constructor

		Arguments:
		- subscription_backup - object that can retrieve subscription backup
		  object for each subscription, list of servers with backups
		"""
		self._subscription_backup = subscription_backup

	def filter_subscription(self, global_context, subscription):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		subscription_backup = self._subscription_backup.get(subscription)

		if subscription_backup is None:
			return False

		return self._filter_subscription_backup(global_context, subscription, subscription_backup)

	def run(self, global_context, subscription):
		"""Run action on given subscription

		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		subscription_backup = self._subscription_backup.get(subscription)

		if subscription_backup is None:
			# subscription does not exist in backup - simply skip it
			return

		self._run_subscription_backup(global_context, subscription, subscription_backup)

	def _filter_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		return True

	def _run_subscription_backup(
		self, global_context, subscription, subscription_backup
	):
		"""Run action on single subscription on provided backup

		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		raise NotImplementedError()