from parallels.core.utils.common import default
from parallels.core.utils.entity import Entity


class CopyWebContentItem(Entity):
	def __init__(self, source_path, target_path, skip_if_source_not_exists=False, exclude=None, domain_name=None):
		"""
		:type source_path: parallels.core.utils.web_paths.WebHostingPath
		:type target_path: parallels.core.utils.web_paths.WebHostingPath
		:type skip_if_source_not_exists: bool
		:type exclude: list[basestring]
		"""
		self._source_path = source_path
		self._target_path = target_path
		self._skip_if_source_not_exists = skip_if_source_not_exists
		self._exclude = default(exclude, [])
		self._domain_name = domain_name

	@property
	def source_path(self):
		"""
		:rtype: parallels.core.utils.web_paths.WebHostingPath
		"""
		return self._source_path

	@property
	def target_path(self):
		"""
		:rtype: parallels.core.utils.web_paths.WebHostingPath
		"""
		return self._target_path

	@property
	def skip_if_source_not_exists(self):
		"""
		:rtype: bool
		"""
		return self._skip_if_source_not_exists

	@property
	def exclude(self):
		"""
		:rtype: list[basestring]
		"""
		return self._exclude

	@property
	def domain_name(self):
		"""Domain name this content is related to. Could be None

		:rtype: basestring | None
		"""
		return self._domain_name


class BaseWebPathConverter(object):
	"""Class to convert abstract path descriptor to concrete absolute path"""

	def expand(self, path, server):
		"""Convert abstract path descriptor to concrete absolute path

		:type path: parallels.core.utils.web_paths.WebHostingPath
		:rtype: str | unicode
		"""
		raise NotImplementedError()