import logging

from parallels.plesk.utils.xml_rpc.plesk import operator as plesk_ops
from parallels.core.utils.plesk_api_utils import check_if_subscription_exists
from parallels.core.actions.hosting_settings.verify_base import VerifyHostingSettingsBase

logger = logging.getLogger(__name__)

class VerifyHostingSettings(VerifyHostingSettingsBase):
	@staticmethod
	def _get_missing_sites(subscription):
		"""
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		"""
		site_names = set(
			site.name for site in subscription.converted_dump.iter_sites()
		)
		missing_sites = set()
		for site_name in site_names:
			request = plesk_ops.SiteOperator.Get(
				filter=plesk_ops.SiteOperator.FilterByName([site_name]),
				dataset=[plesk_ops.SiteOperator.Dataset.GEN_INFO]
			)
			results = subscription.panel_target_server.plesk_api().send(request)
			site_missing = True
			for result in results:
				if not hasattr(result, 'code') or result.code != 1013:
					if result.data[1].gen_info.name == site_name:
						site_missing = False
			if site_missing:
				missing_sites.add(site_name)
		return missing_sites

	@staticmethod
	def _check_if_subscription_exists(subscription):
		return check_if_subscription_exists(subscription.panel_target_server.plesk_api(), subscription.name)
