from parallels.core.utils.common import unused
from parallels.core import version_tuple

from .client import Client

unused(Client)  # To import as parallels.plesk.utils.xml_rpc.plesk.Client

# The mapping is created according to Plesk Panel API RPC Developers's Guide
# (http://download1.parallels.com/Plesk/PP10/10.4.4/Doc/en-US/online/plesk-api-rpc-guide/index.htm?fileName=28709.htm)
api_versions = {
	'8.0.1' 	: '1.4.1.2',
	'8.1.0' 	: '1.4.2.0',
	'8.1.1' 	: '1.5.0.0',
	'8.2' 		: '1.5.1.0',
	'8.3' 		: '1.5.2.0',
	'8.4' 		: '1.5.2.1',
	'9.0.0' 	: '1.6.0.0',
	'9.0.1' 	: '1.6.0.1',
	'9.0.2' 	: '1.6.0.2',
	'10.0' 		: '1.6.3.0',
	'10.1' 		: '1.6.3.1',
	'10.2' 		: '1.6.3.2',
	'10.3' 		: '1.6.3.3',
	'10.4' 		: '1.6.3.4',
	'11.1' 		: '1.6.4.0',
	'11.5' 		: '1.6.5.0',
	'12.0' 		: '1.6.6.0',
}


def get_max_supported_api_version(current_plesk_version):
	"""Find maximum API version we support for given Plesk version"""
	current_plesk_version_tuple = version_tuple(current_plesk_version)
	available_versions = [ 
		api_version for plesk_version, api_version in api_versions.iteritems()
		if version_tuple(plesk_version) <= current_plesk_version_tuple
	]
	if len(available_versions) == 0:
		raise Exception(u"Plesk %s API is not supported" % (current_plesk_version,))
	return max(available_versions)
