from parallels.core.actions.base.compound_action import CompoundAction
from parallels.core.actions.content.database.copy_database_content import CopyDatabaseContent
from parallels.core.utils.backup_adapter import SubscriptionBackup
from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.plesk.actions.hosting_settings.convert.dns import DNS
from parallels.plesk.source.custom.actions.content.database.restore_db_dumps import RestoreDBDumps
from parallels.plesk.source.custom.actions.content.mail.copy_mail_messages import CopyMailMessages
from parallels.plesk.source.custom.actions.content.web.copy_unix_content import CustomPanelCopyUnixWebContent
from parallels.plesk.source.custom.actions.content.web.copy_unix_content_local import CustomPanelCopyUnixWebContentLocal
from parallels.plesk.source.custom.actions.content.web.copy_windows_content import CustomPanelCopyWindowsWebContent
from parallels.plesk.source.custom.actions.content.web.copy_windows_content_local import (
	CustomPanelCopyWindowsWebContentLocal
)
from parallels.plesk.source.custom.actions.dump.create_converted_dump_from_raw_dump import (
	CustomPanelCreateConvertedDumpFromRawDump
)
from parallels.plesk.source.custom.actions.dump.create_dump_from_hosting_description import (
	CreateDumpFromHostingDescription
)


class WorkflowExtension(WorkflowExtensionBase):
	def extend_workflow(self, workflow):
		"""Extend shared hosting workflow with source-panel specific actions

		:type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
		"""
		workflow.get_shared_action('fetch-source').insert_action(
			'create-dump-from-hosting-description', CreateDumpFromHostingDescription()
		)

		workflow.get_path('generate-migration-list').remove_action('analyse-hosting')

		workflow.get_shared_action('convert-hosting').replace(
			'convert-dns', DNS()
		)

		workflow.get_path('transfer-accounts').replace(
			'fetch-source-shallow', CompoundAction()
		)

		workflow.replace_shared_action('copy-db-content', CompoundAction())
		workflow.get_shared_action('copy-db-content').insert_action(
			'copy-db-from-servers', CopyDatabaseContent()
		)
		workflow.get_shared_action('copy-db-content').insert_action(
			'restore-db-dumps', RestoreDBDumps()
		)
		workflow.replace_shared_action('copy-mail-content', CopyMailMessages())
		workflow.get_shared_action('copy-web-files').insert_action(
			'copy-unix-files', CustomPanelCopyUnixWebContent()
		)
		workflow.get_shared_action('copy-web-files').insert_action(
			'copy-windows-files', CustomPanelCopyWindowsWebContent()
		)
		workflow.get_shared_action('copy-web-files').insert_action(
			'copy-local-windows-files', CustomPanelCopyWindowsWebContentLocal()
		)
		workflow.get_shared_action('copy-web-files').insert_action(
			'copy-local-unix-files', CustomPanelCopyUnixWebContentLocal()
		)

		# no need to check infrastructure in case of migration w/o source server access,
		# so just replace corresponding action with empty action
		workflow.replace_shared_action(
			'check-infrastructure', CompoundAction()
		)

		workflow.get_shared_action('convert-hosting').replace(
			'create-converted-backup',
			CustomPanelCreateConvertedDumpFromRawDump(SubscriptionBackup())
		)