from parallels.core import messages
import os
from parallels.core import MigrationNoContextError
from parallels.core.actions.base.common_action import CommonAction
from parallels.core.actions.utils.logging_properties import LoggingProperties


class QuickCheckCLIOptions(CommonAction):
	def get_description(self):
		return messages.CHECK_THAT_COMMAND_LINE_OPTIONS_ARE

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return messages.FAILED_CHECK_THAT_COMMAND_LINE_OPTIONS

	def run(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		errors = []
		if (
			hasattr(global_context.options, 'migration_list_file') and
			global_context.options.migration_list_file is not None and
			not os.path.exists(global_context.options.migration_list_file)
		):
			errors.append(
				messages.MIGRATION_LIST_FILE_S_SPECIFIED_MIGRATIONLISTFI % (
					global_context.options.migration_list_file
				)
			)
		if (
			hasattr(global_context.options, 'ip_mapping_file') and
			global_context.options.ip_mapping_file is not None and
			not os.path.exists(global_context.options.ip_mapping_file)
		):
			errors.append(
				messages.IP_MAPPING_FILE_S_SPECIFIED_IPMAPPINGFILE % (
					global_context.options.ip_mapping_file
				)
			)

		if len(errors) > 0:
			raise MigrationNoContextError("\n".join(errors))

	def get_logging_properties(self):
		"""Get how action should be logged to migration tools end-user"""
		return LoggingProperties(
			# should not be logged to info.log, action is quick
			# and it makes no sense to let customer know such details
			info_log=False,
			compound=False
		)
