import os
import urllib
import logging
import zipfile

from parallels.core.registry import Registry

logger = logging.getLogger(__name__)


def get_thirdparties_base_path():
	return os.path.join(Registry.get_instance().get_var_dir(), 'thirdparties')


def get_agents_base_path():
	return os.path.join(Registry.get_instance().get_var_dir(), 'agents')


def download(url, path):
	logger.debug('Download %s into %s' % (url, path))
	urllib.urlretrieve(url, path)


def download_zip(url, path):
	zip_path = '%s.zip' % path
	logger.debug('Download %s into %s' % (url, zip_path))
	urllib.urlretrieve(url, zip_path)
	logger.debug('Unzip %s into %s' % (zip_path, path))
	with zipfile.ZipFile(zip_path) as zfp:
		zfp.extractall(path)
	os.remove(zip_path)