from collections import namedtuple

from parallels.core.utils.common import extend_namedtuple
from parallels.core.import_api.model import model_pretty_yaml
from parallels.core.import_api import model

ADMIN_ACCOUNT_ID = model.ADMIN_ACCOUNT_ID
WebspaceStatus = model.WebspaceStatus

PleskContactInfo = model_pretty_yaml(
	extend_namedtuple(model.BaseContactInfo, 'PleskContactInfo')
)
PleskCustomerInfo = model_pretty_yaml(
	extend_namedtuple(model.BaseCustomerInfo, 'PleskCustomerInfo', ('owner_id',))
)
PleskResellerInfo = model_pretty_yaml(
	extend_namedtuple(model.BaseResellerInfo, 'PleskResellerInfo')
)
PleskWebspaceInfoBrief = model_pretty_yaml(
	extend_namedtuple(model.BaseWebspaceInfoBrief, 'PleskWebspaceInfoBrief')
)
PleskWebspaceInfo = model_pretty_yaml(
	extend_namedtuple(model.BaseWebspaceInfo, 'PleskWebspaceInfo', ('htype',))
)
PleskSubscriptionInfo = model_pretty_yaml(
	extend_namedtuple(model.BaseSubscriptionInfo, 'PleskSubscriptionInfo')
)
PleskServiceTemplateInfo = model_pretty_yaml(
	extend_namedtuple(model.BaseServiceTemplateInfo, 'PleskServiceTemplateInfo')
)
PleskServiceTemplateDetails = model_pretty_yaml(
	extend_namedtuple(model.BaseServiceTemplateDetails, 'PleskServiceTemplateDetails', ('database_servers', 'shell'))
)
PleskDatabaseServerInfo = model_pretty_yaml(
	namedtuple('PleskDatabaseServerInfo', ('host', 'port', 'type'))
)
