from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.plesk.source.plesk.workflow import WorkflowExtension as SourcePleskWorkflowExtension


class WorkflowExtension(WorkflowExtensionBase):
	def extend_workflow(self, workflow):
		"""Extend shared hosting workflow with source-panel specific actions

		:type workflow: parallels.core.workflow.base_workflow.BaseWorkflow
		"""
		# Mostly the same as Plesk workflow
		SourcePleskWorkflowExtension().extend_workflow(workflow)

		# Remove check capability actions, as this is not implemented for PPA
		# (for PPA 11.6 fails with "Capability section 'apache-modules' is not supported")
		workflow.get_shared_action('fetch-source').remove_action('fetch-capability-info')
		workflow.get_path('check/check-data').remove_action('check-capability')
		workflow.get_shared_action('convert-hosting').remove_action('check-capability')