from parallels.core import messages
from parallels.core.actions.base.common_action import CommonAction
from parallels.core import MigrationError


class UndoDNSForwardingNotSupported(CommonAction):
	def get_description(self):
		return messages.CHECK_IF_SOURCE_PANEL_SUPPORTS_DNS

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return messages.FAILED_CHECK_IF_SOURCE_PANEL_SUPPORTS_1

	def run(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		raise MigrationError(
			messages.DNS_FORWARDING_IS_NOT_SUPPORTED_FOR)
