import sys
import logging

from parallels.core import messages
from parallels.core.actions.base.common_action import CommonAction
from parallels.core.actions.migration_list.utils import get_migration_list_file_location

logger = logging.getLogger(__name__)


class WriteMigrationList(CommonAction):
	def get_description(self):
		return messages.ACTION_WRITE_MIGRATION_LIST_FILE

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return messages.FAILED_WRITE_MIGRATION_LIST_FILE

	def run(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		migration_list_file = get_migration_list_file_location(global_context)
		global_context.migrator._get_migration_list_class().write_content(
			migration_list_file,
			sys.__stdin__.read()
		)
		logger.info(messages.MIGRATION_LIST_FILE_TEMPLATE_IS_SAVED, migration_list_file)