from parallels.core import messages
from parallels.core.actions.base.common_action import CommonAction


class TestAllAfterTransfer(CommonAction):
	def get_description(self):
		return messages.TEST_ALL_AFTER_TRANSFER_ACTION_DESCRIPTION

	def filter_action(self, global_context):
		"""Check whether we should run this action or not. By default True - action should be executed.

		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:rtype: bool
		"""
		return global_context.options.run_post_migration_checks

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		return messages.TEST_ALL_AFTER_TRANSFER_ACTION_FAILURE

	def run(self, global_context):
		"""
		:type global_context: parallels.core.global_context.GlobalMigrationContext
		"""
		global_context.migrator._test_all(global_context.options)