from parallels.core.actions.content.web.copy_windows_content_base import CopyWindowsWebContentBase
from parallels.core.utils.paths import web_paths
from parallels.core.utils.paths.copy_web_content import CopyWebContentItem


class CopyWindowsWebContent(CopyWindowsWebContentBase):
	def _list_files_to_copy(self, global_context, subscription):
		"""Make a list of source server directories to be transferred.

		Return a list of (source directory -> destination directory) mappings.

		:type global_context: parallels.core.global_context.GlobalMigrationContext
		:type subscription: parallels.core.migrated_subscription.MigratedSubscription
		:rtype: list[parallels.core.utils.paths.copy_web_content.CopyWebContentItem]
		"""
		vhost_name = subscription.name_idn

		tocopy = [
			# content
			CopyWebContentItem(
				source_path=web_paths.VirtualHostsPath(vhost_name + '/'),
				target_path=web_paths.WebspaceRoot(subscription.converted_dump),
				exclude=[u"/Backup", u"/Certificates", u"/wwwroot", u"/SubDomains"],
				skip_if_source_not_exists=False
			),
			CopyWebContentItem(
				source_path=web_paths.VirtualHostsPath(vhost_name + '/wwwroot/'),
				target_path=web_paths.WebspaceDocumentRoot(subscription.converted_dump),
				exclude=[],
				skip_if_source_not_exists=False
			),
		]

		for site in subscription.converted_dump.iter_subdomains():
			source_site_subdir = "%s/SubDomains/%s/" % (vhost_name, site.short_name.encode('idna'))
			tocopy.extend([
				CopyWebContentItem(
					source_path=web_paths.VirtualHostsPath(source_site_subdir),
					target_path=web_paths.SiteDocumentRoot(subscription.converted_dump, site),
					exclude=[],
					skip_if_source_not_exists=True
				)
			])

		return tocopy
