from parallels.common.actions.base.common_action import CommonAction
from parallels.common.actions.utils.logging_properties \
	import LoggingProperties

class RemoveContent(CommonAction):
	"""Work around Plesk 11.1 being unable to restore content from Plesk 8.6
	for Windows zip archives: cut out content nodes"""

	def __init__(self, subscription_backup):
		"""Class constructor

		Arguments:
		- subscription_backup - object that can retrieve subscription backup
		  object for each subscription, list of servers with backups
		"""
		self._subscription_backup = subscription_backup

	def get_description(self):
		return "Remove content nodes from backups"

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def run(self, global_context):
		server_settings = self._subscription_backup.iter_server_settings(
			global_context
		) 
		for settings in server_settings:
			backup = global_context.load_converted_plesk_backup(settings)

			if backup.container.agent_name == 'pre9-backup-converter' and backup.is_windows:
				backup.remove_content()
