from parallels.common.actions.base.base_action \
	import BaseAction

class CompoundAction(BaseAction):
	"""Action in workflow which consists of other actions"""
	def __init__(self, description=None):
		self._actions = []
		self._description = description

	def get_description(self):
		return self._description

	def insert_action(self, name, action, after=None, before=None):
		self.insert_actions(
			[(name, action,)], after=after, before=before
		)

	def replace(self, name, action):
		new_actions = []
		for existing_name, existing_action in self._actions:
			if name == existing_name:
				new_actions.append((name, action))
			else:
				new_actions.append((existing_name, existing_action))

		self._actions = new_actions

	def insert_actions(self, actions, after=None, before=None):
		assert after is None or before is None
		i = 0
		for i, (name, _) in enumerate(self._actions):
			if name == after:
				break
			if name == before:
				i -= 1
				break
		for j, action in enumerate(actions):
			self._actions.insert(i + j + 1, action)

	def get_action(self, name):
		return dict(self._actions)[name]

	def get_all_actions(self):
		return self._actions

	def get_path(self, path):
		current = self
		for item in path.split('/'):
			current = current.get_action(item)
		return current