
class MigrationSubscription(object):
	"""Objects that represents subscription that we are migrating"""

	@property
	def raw_backup(self):
		"""Return subscription from raw backup
		
		Raw backup contains subscriptions like they are
		presented on source panel.

		Returns common.plesk_backup.data_model.Subscription*
		"""
		raise NotImplementedError()

	@property
	def converted_backup(self):
		"""Return subscription from converted backup

		Converted backup contains subscription how 
		we are going to restore them on the target panel.
		So IP addresses are changed, unsupported features are removed,
		etc.

		Returns common.plesk_backup.data_model.Subscription*
		"""
		raise NotImplementedError()

	@property
	def model(self):
		"""Return target data model subscription
		
		Returns common.target_data_model.Subscription
		"""
		raise NotImplementedError()

	@property
	def target_mail_ip(self):
		"""Return target mail server IP"""
		raise NotImplementedError()

	@property
	def target_web_ip(self):
		"""Return target web server IP"""
		raise NotImplementedError()

	@property
	def source_mail_ip(self):
		"""Return source mail server IP"""
		raise NotImplementedError()

	@property
	def target_dns_ips(self_):
		"""Return IP addresses of target DNS servers"""
		raise NotImplementedError()

	@property
	def source_dns_ips(self_):
		"""Return IP addresses of source DNS servers"""
		raise NotImplementedError()

	@property
	def is_windows(self):
		"""Whether the subscription is Windows or Unix"""
		raise NotImplementedError()

	@property
	def is_fake(self):
		"""Check if domain is fake - created by technical reasons 
		
		Fake domains may be not existent on source server, and so they should
		not checked. 
		"""
		raise NotImplementedError()

	@property
	def web_target_server(self, subscription_name):
		raise NotImplementedError()

