from parallels.common.utils import plesk_utils

class HostingServer(object):
	"""Common features of Plesk hosting server, panel independent."""
	vhost_log_files = [
		'{vhost_root}/system/{domain}/logs/error_log'
	]

	def __init__(self, server):
		"""Initialize with an object of type 'TargetServer'."""
		self.server = server

	def get_unix_vhost_dirs(self, runner, domain_name):
		"""
		Return a list of domain hosting content directories.

		Arguments:
			runner: XXX Remove unused parameter
			domain_name: Plesk domain name
		Returns:
			A list of directories.
		"""
		with self.server.runner() as runner:
			dir = plesk_utils.get_unix_vhost_dir(runner, domain_name)
		return [dir]

	def get_unix_vhost_error_log_files(self, domain_name):
		"""Return a list of domain error log files."""
		with self.server.runner() as runner:
			filename_variables = {
				'domain': domain_name.encode('idna'),
				'vhost_root': plesk_utils.get_unix_vhosts_dir(runner),
			}
		return [
			filename.format(**filename_variables)
			for filename in self.vhost_log_files
		]

	def get_unix_domain_mail_dirs(self, runner, domain_name):
		"""
		Return a list of domain mail content directories.

		Arguments:
			runner: XXX Remove unused parameter
			domain_name: Plesk domain name
		Returns:
			A list of directories.
		"""
		with self.server.runner() as runner:
			dir = plesk_utils.get_unix_domain_mail_dir(runner, domain_name)
		return [dir]
