
class CommonSessionFiles(object):
	"""Common paths to files in migration session directory."""

	def __init__(self, conn, migrator_server):
		"""

		Arguments:
		- conn - instance of common.connections.connections.Connections
		"""
		self._conn = conn
		self._migrator_server = migrator_server

	def get_path_to_raw_plesk_backup(self, server_id):
		return self._migrator_server.get_session_file_path(
			u"plesk.backup.%s.raw.%s" % (
				server_id, self._get_extension(server_id)
			)
		)

	def get_path_to_cut_plesk_backup(self, server_id):
		return self._migrator_server.get_session_file_path(
			u"plesk.backup.%s.cut.%s" % (
				server_id, self._get_extension(server_id)
			)
		)

	def get_path_to_converted_plesk_backup(self, server_id):
		return self._migrator_server.get_session_file_path(
			u"plesk.backup.%s.converted.tar" % (server_id,)
		)

	def get_path_to_apache_restart_interval(self):
		return self._migrator_server.get_session_file_path(
			"original_apache_restart_interval"
		)

	def _get_extension(self, server_id):
		is_windows = self._conn.get_source_node(server_id).is_windows()
		return 'zip' if is_windows else 'tar'
