

class BaseWorkflow(object):
	def __init__(self):
		self._entry_points = dict()
		self._shared_actions = dict()

	def add_entry_point(self, name, entry_point):
		if name in self._entry_points:
			raise Exception("Entry point '%s' already exists" % name)
		self._entry_points[name] = entry_point

	def replace_entry_point(self, name, entry_point):
		if name not in self._entry_points:
			raise Exception(
				"Can not replace entry point '%s' which does not exist" % name
			)
		self._entry_points[name] = entry_point

	def get_entry_point(self, name):
		return self._entry_points[name]

	def get_entry_points(self):
		return self._entry_points

	def get_path(self, path):
		if '/' in path:
			entry_point, action_path = path.split('/', 1)
			return self.get_entry_point(entry_point).get_path(action_path)
		else:
			return self.get_entry_point(path)

	def get_shared_action(self, action_id):
		"""Get action shared between other actions from registry

		To use such action in other actions, you could use the code like
		the following:
		1) Add and configure action to the registry:
		self.add_common_action('common-action-1', CompoundAction())
		# configure action there
		2) Add it to workflow:
			self
				.get_path('entry-point/action1/subaction1')
				.get_common_action('common-action-1')
			You could add it multiple paths in workflow
		"""
		return self._shared_actions[action_id]

	def add_shared_action(self, action_id, action):
		"""Add action that could be shared between other actions to registry

		To use such action in other actions, you could use the code like
		the following:
		1) Add and configure action to the registry:
		self.add_common_action('common-action-1', CompoundAction())
		# configure action there
		2) Add it to workflow:
			self
				.get_path('entry-point/action1/subaction1')
				.get_common_action('common-action-1')
			You could add it multiple paths in workflow
		"""
		self._shared_actions[action_id] = action