from parallels.pmm_unix_migrator.pmm_agent import PmmMigrationAgentBase

class ConfixxPmmMigrationAgent(PmmMigrationAgentBase):
	def __init__(self, migrator_pmm_dir, server, settings):
		cli_options = '--dump-all --configuration-only --server -v 5'
		super(ConfixxPmmMigrationAgent, self).__init__(
			migrator_pmm_dir, server, settings, cli_options
		)

	def get_confixx_config_path(self):
		self.logger.info(u"Get Confixx config file path")

		with self.server.runner() as runner:
			path = runner.sh(
				ur'cd {path}; perl ConfixxConfigPath.pl',
				{
					'path':	self.settings.agent_home,
					'agent': self.settings.agent_script_name
				}
			).strip()
			self.logger.debug("Confixx config path = '%s'", path)
			return path

