from parallels.common.actions.base.common_action import CommonAction
from parallels.common import MigrationError


class UndoNotSupported(CommonAction):
	def get_description(self):
		return "Report that undo DNS forwarding for H-Sphere is not supported"

	def get_failure_message(self, global_context):
		return "Failed to report that undo DNS forwarding for H-Sphere is not supported"

	def run(self, global_context):
		raise MigrationError(
			u"DNS forwarding configuration cannot be undone for this type of migration. "
			u"You can revert the forwarding manually in the DNS server configuration if you want."
		)