from parallels.common.workflow.shared_hosting_workflow import SharedHostingWorkflow
from parallels.common.actions.base.legacy_action \
	import LegacyAction
from parallels.common.actions.base.entry_point_action \
	import EntryPointAction

from parallels.plesks_migrator.actions.content.web.copy_unix_content \
	import CopyUnixWebContent
from parallels.common.actions.content.web.fix_unix_vhost_permissions \
	import FixUnixVhostPermissions
from parallels.plesks_migrator.actions.content.web.fix_unix_vhost_structure \
	import FixUnixVhostStructure
from parallels.plesks_migrator.actions.content.web.fix_unix_permissions_old_plesk \
	import FixUnixPermissionsOldPlesks
from parallels.plesks_migrator.actions.content.web.fix_unix_permissions \
	import FixUnixPermissions
from parallels.plesks_migrator.actions.content.web.copy_windows_content \
	import CopyWindowsWebContent
from parallels.plesks_migrator.actions.content.web.fix_security_files \
	import FixSecurityFiles
from parallels.plesks_migrator.actions.content.web.reset_permissions \
	import ResetPermissions
from parallels.plesks_migrator.actions.aps.restore_applications \
	import RestoreApplications as ActionApsRestoreApplications
from parallels.plesks_migrator.actions.content.web.fix_permissions_for_clients_iis_pools \
	import FixPermissionsForClientsIISPools
from parallels.plesks_migrator.actions.content.web.fix_permissions_for_iis6_domains \
	import FixPermissionsForIIS6Domains
from parallels.plesks_migrator.actions.fetch.fetch_applications \
	import FetchApplicationsAction
from parallels.plesks_migrator.actions.fetch.merge_applications \
	import MergeApplications as FetchMergeApplicationsAction
from parallels.plesks_migrator.actions.fetch.fetch_backup \
	import FetchBackupAction
from parallels.plesks_migrator.actions.content.web.restore_dedicated_application_pool \
	import RestoreDedicatedApplicationPool
from parallels.plesks_migrator.actions.aps.transfer_packages \
	import TransferPackages as ActionApsTransferPackages
from parallels.plesks_migrator.actions.hosting_settings.transfer_virtual_directories \
	import TransferVirtualDirectories
from parallels.plesks_migrator.actions.hosting_settings.transfer_error_documents \
	import TransferErrorDocuments
from parallels.plesks_migrator.actions.hosting_settings.transfer_mime_types \
	import TransferMIMETypes
from parallels.common.actions.dns.forwarding.check_target_panel_supports_forwarding \
	import CheckTargetPanelSupportsForwarding

class FromPleskWorkflow(SharedHostingWorkflow):
	def __init__(self):
		super(FromPleskWorkflow, self).__init__()

		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'copy-files-linux', CopyUnixWebContent()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'fix-unix-vhost-permissions', FixUnixVhostPermissions()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'fix-unix-vhost-structure', FixUnixVhostStructure()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'fix-permissions-old-plesks', FixUnixPermissionsOldPlesks()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'fix-permissions', FixUnixPermissions()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'copy-files-windows', CopyWindowsWebContent()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'fix-security-files', FixSecurityFiles()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'reset-permissions', ResetPermissions()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'fix-permissions-for-client-iis-pools', 
			FixPermissionsForClientsIISPools()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'fix-permissions-for-iis6-domains', 
			FixPermissionsForIIS6Domains()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'transfer-wpb-sites', LegacyAction(
				description='Transfer WPB sites',
				function=lambda ctx: ctx.migrator.transfer_wpb_sites(
					ctx.options, finalize=False
				)
			)
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'restore-aps', ActionApsRestoreApplications()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'transfer-virtual-directories', TransferVirtualDirectories()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'transfer-error-documents', TransferErrorDocuments()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'transfer-mime-types', TransferMIMETypes()
		)

		self.get_shared_action('fetch-source').insert_action(
			'fetch-configuration', FetchBackupAction()
		)
		self.get_shared_action('fetch-source').insert_action(
			'fetch-applications', FetchApplicationsAction()
		)
		self.get_shared_action('fetch-source').insert_action(
			'merge-applications', FetchMergeApplicationsAction()
		)

		self.get_path('transfer-accounts/restore-hosting').insert_action(
			'restore-dedicated-app-pool', RestoreDedicatedApplicationPool()
		)
		self.get_path('transfer-accounts/restore-hosting').insert_action(
			'transfer-aps-packages', ActionApsTransferPackages(),
			after='windows-refresh-components'
		)

		self.replace_entry_point('set-dns-forwarding', EntryPointAction())
		self.replace_entry_point('undo-dns-forwarding', EntryPointAction())

		self.get_path('set-dns-forwarding').insert_action(
			'check-target-panel-supports-forwarding', CheckTargetPanelSupportsForwarding()
		)
		self.get_path('set-dns-forwarding').insert_action(
			'check-connections', LegacyAction(
				description='Check connections',
				function=lambda ctx: ctx.migrator._check_connections(ctx.options)
			)
		)
		self.get_path('set-dns-forwarding').insert_action(
			'read-migration-list', LegacyAction(
				description='Read migration list',
				function=lambda ctx: ctx.migrator._read_migration_list_lazy(ctx.options)
			)
		)
		self.get_path('set-dns-forwarding').insert_action(
			'forward-dns', LegacyAction(
				description='Forward DNS',
				function=lambda ctx: ctx.migrator._forward_dns(ctx.dns_forwarding_report)
			)
		)
		self.get_path('set-dns-forwarding').insert_action(
			'print-report', LegacyAction(
				description='Print DNS forwarding report',
				function=lambda ctx: ctx.migrator._print_dns_forwarding_report(ctx.dns_forwarding_report)
			)
		)

		self.get_path('undo-dns-forwarding').insert_action(
			'check-target-panel-supports-forwarding', CheckTargetPanelSupportsForwarding()
		)
		self.get_path('undo-dns-forwarding').insert_action(
			'check-connections', LegacyAction(
				description='Check connections',
				function=lambda ctx: ctx.migrator._check_connections(ctx.options)
			)
		)
		self.get_path('undo-dns-forwarding').insert_action(
			'read-migration-list', LegacyAction(
				description='Read migration list',
				function=lambda ctx: ctx.migrator._read_migration_list_lazy(ctx.options)
			)
		)
		self.get_path('undo-dns-forwarding').insert_action(
			'forward-dns', LegacyAction(
				description='Undo DNS forwarding',
				function=lambda ctx: ctx.migrator._undo_dns_forwarding(ctx.dns_forwarding_report)
			)
		)
		self.get_path('undo-dns-forwarding').insert_action(
			'print-report', LegacyAction(
				description='Print DNS forwarding report',
				function=lambda ctx: ctx.migrator._print_dns_forwarding_report(ctx.dns_forwarding_report)
			)
		)


		# Set up low DNS timings
		self.replace_entry_point('set-low-dns-timings', EntryPointAction())
		self.get_path('set-low-dns-timings').insert_action(
			'set-low-dns-timings', LegacyAction(
				description="Set low DNS timings",
				function=lambda ctx: ctx.migrator.set_low_dns_timings(ctx.options)
			)
		)
