import logging
import shutil

from parallels.common.actions.base.subscription_action import SubscriptionAction
from parallels.common.plesk_backup import plesk_backup_xml
from parallels.common.target_panels import TargetPanels

logger = logging.getLogger(__name__)


class CreatePerSubscription(SubscriptionAction):
	def get_description(self):
		return "Create separate backup file for subscription"

	def get_failure_message(self, global_context, subscription):
		return "Failed to create separate backup file for subscription '%s'" % (
			subscription.name
		)

	def filter_subscription(self, global_context, subscription):
		return True

	def run(self, global_context, subscription):
		session_files = global_context.session_files
		full_converted_backup_path = session_files.get_path_to_converted_plesk_backup(
			subscription.model.source
		)

		domain_converted_backup_path = session_files.get_path_to_converted_plesk_domain_backup(
			subscription.model.source, subscription.name
		)
		tmp_filename = u"%s.tmp" % domain_converted_backup_path

		shutil.copy2(full_converted_backup_path, domain_converted_backup_path)

		def load_unfiltered_backup(backup_filename):
			return plesk_backup_xml.load_backup(
				backup_filename,
				None,
				# XXX expand-specific properties in common action
				is_expand_mode=global_context.migrator.is_expand_mode(),
				discard_mailsystem=global_context.migrator._is_mail_centralized(
					subscription.model.source
				)
			)

		backup = load_unfiltered_backup(domain_converted_backup_path)
		backup.cut_irrelevant_subcriptions([subscription.name])

		with open(tmp_filename, 'wb') as backup_file:
			backup.save(
				backup_file,
				'zip' if (
					global_context.conn.target.is_windows
					and
					global_context.target_panel == TargetPanels.PPA_WEB_SN
				) else 'tar'
			)
		shutil.copy2(tmp_filename, domain_converted_backup_path)