from parallels.common.actions.base.base_action \
	import BaseAction

class CommonAction(BaseAction):
	"""Base class for migration process action

	Action is a single operation in migration process

	Examples of actions: copy web content, copy mail messages, fetch
	information from source panel, etc
	"""

	def is_critical(self):
		"""If action is critical or not

		If action is critical and it failed, migration tool completely stops.
		Otherwise it proceeds to the next steps of migrations.
		"""
		return True

	def get_failure_message(self, global_context):
		"""Get message for situation when action failed

		This message should contain impact and ways to resolve or work the
		problem around

		Arguments:
		- global_context - registry with different objects that reused among
		  different actions
		"""
		raise NotImplementedError()

	def run(self, global_context):
		"""Run action

		Arguments:
		- global_context - registry with different objects that reused among
		  different actions
		"""
		raise NotImplementedError()