from parallels.common.actions.base.common_action import CommonAction
from parallels.common.actions.utils.logging_properties import LoggingProperties


class RemoveSSHKeys(CommonAction):
	def get_description(self):
		return "Remove temporary SSH keys"

	def get_failure_message(self, global_context):
		return "Failed to remove temporary SSH keys"

	def run(self, global_context):
		global_context.ssh_key_pool.remove_all()

	def get_logging_properties(self):
		"""Get how action should be logged to migration tools end-user"""
		return LoggingProperties(info_log=False)