from parallels.utils import cached


class GlobalMigrationContext(object):
	@staticmethod
	@cached
	def get_instance():
		"""Single instance for GlobalMigrationContext

		:rtype : GlobalMigrationContext
		"""
		return GlobalMigrationContext()

	def __init__(self):
		self.conn = None # connections to source and target servers
		self.session_files = None # utility class to construct paths to session files
		self.migrator_server = None # instance of MigratorServer
		self.import_api = None
		self.safe = None
		self.webmail_ipv4 = None
		self.target_panel = None
		self.target_panel_obj = None
		self.load_raw_plesk_backup = None
		self.load_converted_plesk_backup = None
		self.source_plesks = None
		self.migration_list_data = None
		self.iter_all_subscriptions = None
		self.options = None
		self.password_holder = None
		self.config = None
		self.target_existing_objects = None
		self.source_has_dns_forwarding = True
		self.ssh_key_pool = None
		self.rsync_pool = None
		self.get_rsync = None

		self.dns_forwarding_report = None
		self.pre_check_report = None
		self.post_migration_check_report = None
		self.test_services_report = None

		# XXX Migrator object, for legacy actions - do not use for new code
		# avoid usage for old code
		self.migrator = None

	@property
	def target_model(self):
		return self.migrator._load_ppa_model()