from parallels.common.connections.target_servers import TargetServers
from parallels.common.hosting_check.entity_source.service import TargetServiceInfo
from parallels.target_panel_ppa.panel import PPATargetPanel
from parallels.target_panel_ppa_web_sn.connections.target_server import PPAMoveWebspacesTargetServer
from parallels.utils import cached


class PPAMoveWebspacesTargetPanel(PPATargetPanel):
	@property
	def name(self):
		return 'PPA Web Service Node'

	def has_dns_forwarding(self):
		"""Whether panel should support DNS forwarding migration feature"""
		return False

	@cached
	def get_subscription_nodes(self, conn, subscription_target_services, subscription_name):
		return TargetServers(
			web=PPAMoveWebspacesTargetServer(conn),
			mail=None,
			database={},
			dns=[]
		)

	def get_service_nodes(self, conn):
		return [
			TargetServiceInfo(
				service_type='web',
				node=PPAMoveWebspacesTargetServer(conn)
			)
		]

