from parallels.common.actions.base.common_action import CommonAction
from parallels.common.actions.utils.logging_properties import LoggingProperties
from parallels.common.connections.ssh.connection_pool import SSHConnectionPool


class CloseSSHConnections(CommonAction):
	def get_description(self):
		return "Close SSH connections"

	def get_failure_message(self, global_context):
		return "Failed to close SSH connections"

	def run(self, global_context):
		SSHConnectionPool.get_instance().close_all()

	def get_logging_properties(self):
		"""Get how action should be logged to migration tools end-user"""
		return LoggingProperties(info_log=False)