class CommonSessionFiles(object):
	"""Common paths to files in migration session directory."""

	def __init__(self, conn, migrator_server):
		"""

		Arguments:
		- conn - instance of common.connections.connections.Connections
		"""
		self._conn = conn
		self._migrator_server = migrator_server

	def get_path_to_raw_plesk_backup(self, server_id):
		return self._migrator_server.get_session_file_path(
			u"plesk.backup.%s.raw.%s" % (
				server_id, self._get_extension(server_id)
			)
		)

	def get_path_to_raw_plesk_backup_selection(self, server_id):
		return self._migrator_server.get_session_file_path(
			u"plesk.backup.%s.selection.yaml" % (
				server_id
			)
		)

	def get_path_to_shallow_plesk_backup(self, server_id):
		return self._migrator_server.get_session_file_path(
			u"plesk.backup.%s.shallow.xml" % (
				server_id
			)
		)

	def get_path_to_cut_plesk_backup(self, server_id):
		return self._migrator_server.get_session_file_path(
			u"plesk.backup.%s.cut.%s" % (
				server_id, self._get_extension(server_id)
			)
		)

	def get_path_to_converted_plesk_backup(self, server_id):
		return self._migrator_server.get_session_file_path(
			u"plesk.backup.%s.converted.%s" % (server_id, self._get_target_extension())
		)

	def get_path_to_converted_plesk_domain_backup(self, server_id, domain_name):
		return self._migrator_server.get_session_file_path(
			u"plesk.backup.%s.%s.converted.%s" % (server_id, domain_name.encode('idna'), self._get_target_extension())
		)

	def get_path_to_apache_restart_interval(self):
		return self._migrator_server.get_session_file_path(
			"original_apache_restart_interval"
		)

	def get_path_to_ssh_keys_pool(self):
		return self._migrator_server.get_session_file_path(
			"ssh_key_pool.yaml"
		)

	def _get_extension(self, server_id):
		is_windows = self._conn.get_source_node(server_id).is_windows()
		return 'zip' if is_windows else 'tar'

	def _get_target_extension(self):
		return 'zip' if self._conn.target.is_windows else 'tar'

	def get_path_to_migration_agent(self):
		return self._migrator_server.get_session_file_path('migration_agent_path')

	def get_path_to_rsync(self):
		return self._migrator_server.get_session_file_path('rsync_path_')