import logging
from parallels.plesk_api.operator import IpAddressInfo
from parallels.target_panel_plesk.import_api.import_api_unix import PleskUnixImportAPI
from parallels.utils import cached

logger = logging.getLogger(__name__)


class PPAMoveWebspacesPleskUnixImportAPI(PleskUnixImportAPI):
	def __init__(self, conn, global_context):
		super(PPAMoveWebspacesPleskUnixImportAPI, self).__init__(conn)
		self.global_context = global_context

	def get_hosting_subscription_ip(self):
		return self.global_context.webspace_ipv4

	@cached
	def get_all_ips(self):
		ips = []
		if self.global_context.webspace_ipv4 is not None:
			ips.append(IpAddressInfo(
				ip_address=self.global_context.webspace_ipv4,
				ip_type=self.global_context.webspace_ipv4_type,
				public_ip_address=self.global_context.webspace_ipv4))
		if self.global_context.webspace_ipv6 is not None:
			ips.append(IpAddressInfo(
				ip_address=self.global_context.webspace_ipv6,
				ip_type=self.global_context.webspace_ipv6_type,
				public_ip_address=self.global_context.webspace_ipv6))
		return ips