
class LoggingTransport(object):
	def __init__(self, transport, logger):
		self.transport = transport
		self.logger = logger

	def request(self, host, handler, request_body, verbose=0):
		self.logger.debug(u'XML-RPC request to %s:\n%s' % (host, request_body.decode('utf-8')))
		response = self.transport.request(host, handler, request_body, verbose)
		self.logger.debug(u"XML-RPC response from %s:\n%s", host, response)
		return response

	def close(self):
		self.transport.close()
