import logging
import os

from parallels.common import MigrationError
from parallels.common.actions.base.common_action import CommonAction
from parallels.common.actions.migration_list.utils import get_migration_list_file_location

logger = logging.getLogger(__name__)


class CheckIfMigrationListExists(CommonAction):
	def get_description(self):
		return "Check if migration list file already exists"

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return "Failed to check if migration list file already exists"

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		migration_list_file = get_migration_list_file_location(global_context)

		if os.path.exists(migration_list_file):
			if not global_context.options.overwrite:
				raise MigrationError(
					u"Migration list file '%s' already exists. To overwrite it, "
					"use --overwrite option""" % (migration_list_file,)
				)
			else:
				logger.info(
					u"Migration list file '%s' already exists, overwrite it",
					migration_list_file
				)