from collections import namedtuple

from .. import core
from parallels.utils.xml import elem, text_elem

PleskCentralizedDbServerData = namedtuple('PleskCentralizedDbServerData', ('host', 'is_local'))

class PleskCentralizedDbServerOperator:
	class Get(namedtuple('Get', ('filter'))):
		class FilterAll:
			def inner_xml(self): return []

		class FilterByPleskServerId(namedtuple('FilterByPleskServerId', ('ids',))):
			def inner_xml(self):
				return [text_elem('server_id', plesk_server_id) for plesk_server_id in self.ids]

		operator_name = 'exp_plesk_centralized_db'
		operation_name = 'get'

		def inner_xml(self):
			return [
				elem('filter', self.filter.inner_xml()),
			]
			
		@classmethod
		def parse(cls, elem):
			return [core.Result.parse(r, cls._parse_data) for r in elem.findall('result')]
		
		@classmethod
		def _parse_data(cls, elem):
			return PleskCentralizedDbServerData(
				host=elem.findtext('data/host'),
				is_local=(elem.find('data/local') is not None)
			)


