'******************************************************************************
' This Function creates zip archive from all the content of the specified folder
'******************************************************************************
Function ZipFolderContent( folder, zipFile)
        Dim oApp, oFolder

        Set oApp = CreateObject("Shell.Application")
        Set oFolder = oApp.NameSpace(folder)
        If Not oFolder Is Nothing Then
                CreateEmptyZip(zipFile)
                oApp.NameSpace(zipFile).CopyHere oFolder.Items
                Do Until oApp.NameSpace(zipFile).Items.Count = oFolder.Items.Count
                        wScript.Sleep 1000
                Loop
        End If

        Set oApp = Nothing
End Function


'******************************************************************************
' This Function creates empty zip archive with given file name.
'  The file name extention should be ".zip".
'******************************************************************************
Function CreateEmptyZip( fileName )
        Const ForWriting = 2
        Dim oFSO, oTxt

        Set oFSO = CreateObject( "Scripting.FileSystemObject" )
        Set oTxt = oFSO.OpenTextFile( fileName, ForWriting, True )
        oTxt.Write "PK" & Chr(5) & Chr(6) & String( 18, Chr(0) )
        oTxt.Close

        Set oTxt = Nothing
        Set oFSO = Nothing
End Function


'******************************************************************************
' Service functions for Main
'******************************************************************************
Sub Syntax()
	WScript.Echo "Syntax: zipfolder.vbs folder zipFile"
	WScript.Quit 1
End Sub

Sub Die( message, code )
	WScript.Echo message
	WScript.Quit code
End Sub


'******************************************************************************
' Main
'******************************************************************************
If WScript.Arguments.Count <> 2 Then
	WScript.Echo "Syntax: zipfolder.vbs folder zipFile"
	WScript.Quit 1
End If
folder = WScript.Arguments(0)
zipFile = WScript.Arguments(1)
Set oFSO = CreateObject("Scripting.FileSystemObject")
If Not oFSO.FolderExists(folder) Then
	Call Die("ERROR: Folder " & folder & " does not exist", 2)
Else
	folderPath = oFSO.GetAbsolutePathname(folder)
End If
If Not Right(zipFile, 4) = ".zip" Then
	Call Die("ERROR: File " & zipFile & " does not have proper extension (.zip)", 15000)
Else
	zipFilePath = oFSO.GetAbsolutePathname(zipFile)
End If
ZipFolderContent folderPath, zipFilePath
