import os
from parallels.common import MigrationNoContextError
from parallels.common.actions.base.common_action import CommonAction
from parallels.common.actions.utils.logging_properties import LoggingProperties


class QuickCheckCLIOptions(CommonAction):
	def get_description(self):
		return "Check that command line options are correct"

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return "Failed to check that command line options are correct"

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		errors = []
		if (
			hasattr(global_context.options, 'migration_list_file') and
			global_context.options.migration_list_file is not None and
			not os.path.exists(global_context.options.migration_list_file)
		):
			errors.append(
				"Migration list file '%s' specified with --migration-list-file option does not exist. "
				"Check that correct path to migration list is specified." % (
					global_context.options.migration_list_file
				)
			)
		if (
			hasattr(global_context.options, 'ip_mapping_file') and
			global_context.options.ip_mapping_file is not None and
			not os.path.exists(global_context.options.ip_mapping_file)
		):
			errors.append(
				"IP mapping file '%s' specified with --ip-mapping-file option does not exist. "
				"Check that correct path to IP mapping file is specified." % (
					global_context.options.ip_mapping_file
				)
			)

		if len(errors) > 0:
			raise MigrationNoContextError("\n".join(errors))

	def get_logging_properties(self):
		"""Get how action should be logged to migration tools end-user"""
		return LoggingProperties(
			# should not be logged to info.log, action is quick
			# and it makes no sense to let customer know such details
			info_log=False,
			compound=False
		)