
class MultithreadingProperties(object):
	"""Properties describing how subscription action can use multithreading"""

	def __init__(self, can_use_threads=False, use_threads_by_default=False):
		if not can_use_threads and use_threads_by_default:
			raise Exception("Invalid combination of multithreading options")

		self._can_use_threads = can_use_threads
		self._use_threads_by_default = use_threads_by_default

	@property
	def can_use_threads(self):
		return self._can_use_threads

	@property
	def use_threads_by_default(self):
		return self._use_threads_by_default